// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2004 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedure for creating a true One Time Pad file.
//.................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	HWND				hDialogModeLess;
extern	HWND				hDlgCurrent;
extern	BOOL				bProcessInProgress;
extern	BOOL				bCancelOperation;
extern	int					iStepIncrement;
extern	NUMBERFMT			nFormatInfo;
extern	TCHAR				szDestination[MAX_PATH];
extern	BOOL				bAviClipOK;
extern	HWND				hAviClip;
extern	TCHAR				szRoot[16];
extern	int					iWhichAviClip;
extern	LPCTSTR				lpszWhichDriveIcon;
extern	LPCTSTR				lpszCdRom;
extern	LPCTSTR				lpszDisk35;
extern	LPCTSTR				lpszDisk525;
extern	LPCTSTR				lpszHardDisk;
extern	LPCTSTR				lpszRemoteDisk;
extern	HICON				hIcon;
extern	LPTSTR				lpszDestinationFormat;
extern	SHFILEINFO			shfi1;
extern	HANDLE				hOutPutFile;
extern	LARGE_INTEGER		liHalfPercent;
extern	LARGE_INTEGER		liHalfPercentDup;
extern	int					iSkipCounter;
extern	int					iInitialSkipValue;
extern	UINT				uTimer;
extern	DWORD				dwElapHours;
extern	DWORD				dwElapMinutes;
extern	DWORD				dwElapSeconds;
extern	HWND				hStatusBar;
extern	BOOL				bDisplayRingsOnStatusBar;
extern	TCHAR				szStatusBarRings[127];
extern	BOOL				bUseTimeStampCounter;
extern	SHACONTEXT			ShaContext;
extern	BYTE				ShaDigest[SHA_DIGEST_SIZE];

// Variables for the True One Time Pad File procedure.
//....................................................
LPTSTR			lpszMegabytesFree = "You have %s Megabytes free on the destination drive.";
LPTSTR			lpszSizeCreated = "Size of True One Time Pad: %s Megabyte(s).";
ULARGE_INTEGER	uliBytesFree;
ULARGE_INTEGER	uliMegabytes;
ULARGE_INTEGER	uliSize;

BYTE			PadFileID[] = "pad1";

BYTE			PadHeader[] = {0x70, 0x61, 0x64, 0x31, 0x0c, 0x00, 0x00,
							   0x00, 0x00, 0x00, 0x00, 0x00};

// Make a true one time pad file.
//...............................
VOID MakeATrueOneTimePad()
{
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	ULARGE_INTEGER		uliFreeBytes;
	LPBYTE				lpOutBuffer = 0;
	LPBYTE				lpOutBufferDup;
	BOOL				bResult;
	DWORD				dwOldHelpTopic;
	DWORD				dwBytesWritten;
	DWORD				dwBufferSize;
	BOOL				bDiskError;
	UINT				uiDriveType;
	int					iResult;
	OPENFILENAME		ofn;
	HANDLE				hSearch;
	WIN32_FIND_DATA		wfd;

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_TRUEONETIMEPADS);
	bAviClipOK = FALSE;
	bDiskError = FALSE;

	if (BPC())
	{
		goto TrueEnd;
	}
	// Setup the skip counters for the CheckForMessages function.
	//...........................................................
	__asm
	{
		mov		iSkipCounter,250
		mov		iInitialSkipValue,250
	}

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_TOTPFILES);

	// Initialize with specific information for getting a true pad file name.
	//.......................................................................
	ofn.lpstrFile = szDestination;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("True One Time Pad Files [.pad]\0*.pad\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Save True One Time Pad File As");
	ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_NONETWORKBUTTON | 
				 OFN_ENABLEHOOK | OFN_ENABLESIZING |OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = TEXT("pad");
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szDestination,MAX_PATH);

		// Get the name and path we want to use for our public key ring.
		//..............................................................
		if (!GetSaveFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_SAVE_AS);
			goto TrueEnd;
		}
		SaveDirName((LPBYTE)&szDestination,SAVE_TOTPFILES | SAVE_SOURCE,TRUE);

		// Determine how much memory we have on the disk drive. Has to be 1 meg
		// or better.
		//.....................................................................
		ZeroMemory(&szRoot,sizeof(szRoot));
		CopyMemory(&szRoot,&szDestination,3);
		
		bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
									(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
									(PULARGE_INTEGER)&uliTotalBytes.QuadPart,
									(PULARGE_INTEGER)&uliFreeBytes);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
			goto TrueEnd;
		}
		if (uliFreeCallerBytes.QuadPart < ONEMEGABYTE)
		{
			SetLastError(IDS_INSUFFICIENTSPACE);
			ErrorProcedure((LPTSTR)&szDestination,IDS_GETFREEDSKSPACE,MB_OK);
			continue;
		}
		// Make sure we have a valid drive type.
		//......................................
		uiDriveType = GetDriveType((LPCTSTR)&szRoot);

		// We do not want to store the files on a ram disk.
		//.................................................
		if (uiDriveType == DRIVE_RAMDISK)
		{
			SetLastError(IDS_RAMDRIVE);
			ErrorProcedure((LPTSTR)&szDestination,IDS_GETDRIVETYPE,MB_OK);
			continue;
		}
		// Make sure the file does not already exist.
		//...........................................
		hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			break;
		}
		EmptyTheMessageQue();

		// The file exists, warn the user so he can enter another
		// file name.
		//.......................................................
		FindClose(hSearch);
		SetLastError(IDS_ALREADYEXISTS);
		ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
	}
	uliBytesFree.QuadPart = uliFreeCallerBytes.QuadPart;

	// Create the true one time padfile.
	//..................................
	hOutPutFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,NULL,
							    CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hOutPutFile)
	{
		goto TrueEnd;
	}
	bDiskError = TRUE;

	// Write the pad id and start field to the file.
	//..............................................
	bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,&PadFileID,
						   lstrlen((LPCTSTR)&PadFileID),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto TrueEnd;
	}
	uliSize.QuadPart = 12;
	bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,&uliSize.QuadPart,
						   sizeof(ULARGE_INTEGER),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto TrueEnd;
	}
	// Determine which avi clip to use: file copy, file disk,
	// or file cd rom.
	//.......................................................
	iWhichAviClip = FILE_COPY;
	if (uiDriveType == DRIVE_REMOVABLE && (*szDestination == 0x41 ||
		*szDestination == 0x61 || *szDestination == 0x42 ||
		*szDestination == 0x62))
	{
		iWhichAviClip = FILE_DISK;
	}
	else if (uiDriveType == DRIVE_CDROM)
	{
		iWhichAviClip = FILE_CDROM;
	}
	// Determine the correct drive icon to use for the dialog box.
	//............................................................
	lpszWhichDriveIcon = lpszDisk35;
	if (uiDriveType == DRIVE_CDROM)
	{
		lpszWhichDriveIcon = lpszCdRom;
	}
	else if (uiDriveType == DRIVE_REMOTE)
	{
		lpszWhichDriveIcon = lpszRemoteDisk;
	}
	else if (uiDriveType == DRIVE_FIXED)
	{
		lpszWhichDriveIcon = lpszHardDisk;
	}
	else if (uliTotalBytes.QuadPart < (360 * 1024))
	{
		lpszWhichDriveIcon = lpszDisk525;
	}
	else if (uliTotalBytes.QuadPart < (720 * 1024))
	{
		lpszWhichDriveIcon = lpszDisk35;
	}
	else if (uliTotalBytes.QuadPart < (1229 * 1024))
	{
		lpszWhichDriveIcon = lpszDisk525;
	}
	// Ask how large a true one time pad file we want to make.
	//........................................................
	iResult = DialogBox(hInst,TEXT("TRUEONETIMEPADFILESIZE"),hMainWindow,
					   (DLGPROC)TrueOneTimePadFileSizeProc);

	// Destroy the icon if we used it.
	//................................
	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto TrueEnd;
	}
	// Quit if we canceled.
	//.....................
	if (iResult == IDCANCEL)
	{
		goto TrueEnd;
	}
	// Setup the step increment for the progress bar.
	// Always equals one for this case.
	//...............................................
	iStepIncrement = 1;

	// Setup our half percent value for the progress bar.
	//...................................................
	liHalfPercent.QuadPart = uliSize.QuadPart / 256;
	liHalfPercentDup.QuadPart = liHalfPercent.QuadPart;

	// Allocate memory for our buffer.
	//................................
	lpOutBuffer = AllocateMemory(BUFFER_SIZE_IN);
	if (!lpOutBuffer)
	{
		goto TrueEnd;
	}
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("CREATETRUEONETIMEPAD"),hMainWindow,
								  (DLGPROC)CreateTrueOneTimePadProc);

	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto TrueEnd;
	}
	// Setup our elapsed timer.
	//.........................
	dwElapHours = 0;
	dwElapMinutes = 0;
	dwElapSeconds = 0;
	uTimer = SetTimer(hMainWindow,MY_TIMER,1000,(TIMERPROC)My1SecondTimer);
	DisplayZeroTimer();
	EmptyTheMessageQue();

	// Start the avi clip.
	//....................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Play(hAviClip,0,-1,-1);
	}
	// Create the file. We will have a least one megabyte.
	//....................................................
	while(uliSize.QuadPart > 0)
	{	
		lpOutBufferDup = lpOutBuffer;
		dwBufferSize = BUFFER_SIZE_IN;

		while(dwBufferSize > 0)
		{
			GetRandomBits(4096 * 8,lpOutBufferDup);
			liHalfPercent.QuadPart -= 4096;
			if (liHalfPercent.QuadPart <= 0)
			{
				// Update the progress bar.
				//.........................
				SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_STEPIT,0,0);
				liHalfPercent.QuadPart = liHalfPercentDup.QuadPart;
			}
			dwBufferSize -= 4096;
			lpOutBufferDup += 4096;

			if (bUseTimeStampCounter)
			{
				StirTheBits();
			}
			// Check to see if we want to quit.
			//.................................
			EmptyTheMessageQue();
			if (bCancelOperation == TRUE)
			{
				goto TrueEnd;
			}
		}
		// Hash the output 20 bytes at a time with Sha1.
		//..............................................
		HashBuffer(lpOutBuffer,BUFFER_SIZE_IN);

		bResult = WriteMyFile((LPTSTR)&szDestination,hOutPutFile,lpOutBuffer,
							   BUFFER_SIZE_IN,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto TrueEnd;
		}
		uliSize.QuadPart -= BUFFER_SIZE_IN;
	}
	// We have finished creating the true one time pad.
	//.................................................
	bResult = CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
	if (!bResult)
	{
		goto TrueEnd;
	}
	hOutPutFile = 0;
	bDiskError = FALSE;

	// Set the position of the progress bar to 100% if we did not quit
	// or exit with an error
	//................................................................
	if (!bCancelOperation)
	{
		SendMessage(GetDlgItem(hDialogModeLess,IDC_PROGRESS),PBM_SETPOS,(WPARAM)256,0);
	}
	// Make sure bCancelOperation is set to FALSE.
	//............................................
	bCancelOperation = FALSE;

	// Stop the avi clip.
	//...................
	if (bAviClipOK)
	{
		bAviClipOK = Animate_Stop(hAviClip);
	}
	// Change the cancel button to ok.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}

	FlashMyIcon(TRUE);

	// Wait until we close the dialog box to exit.
	//............................................
	while(TRUE)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			break;
		}
	}

  TrueEnd:

	FlashMyIcon(FALSE);

	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Reset the status bar to ready or the name of the key rings.
	//............................................................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,szRoot,sizeof(szRoot));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szRoot);
	}
	if (bAviClipOK)
	{
		Animate_Close(hAviClip);
	}
	if (lpOutBuffer)
	{
		ZeroMemory(lpOutBuffer,BUFFER_SIZE_IN);
		DeallocateMemory(lpOutBuffer);
		lpOutBuffer = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (hOutPutFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hOutPutFile);
		hOutPutFile = 0;
	}
	if (bDiskError)
	{
		DeleteMyFile((LPTSTR)&szDestination);
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for creating a true one time pad.
//.....................................................
LRESULT CALLBACK CreateTrueOneTimePadProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR			szInBuffer[128];
			TCHAR			szFormatedNumber[64];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Open the avi clip and display its first frame
			// in the animation control.
			//..............................................
			hAviClip = GetDlgItem(hDlg,IDC_ANIMATE);
			bAviClipOK = Animate_Open(hAviClip,(LPSTR)iWhichAviClip);

			// Setup the range and step increment for the progress bar.
			//.........................................................
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETRANGE32,0,(LPARAM)256);
			SendMessage(GetDlgItem(hDlg,IDC_PROGRESS),PBM_SETSTEP,(WPARAM)iStepIncrement,0);

			// Setup the name of the true one time pad being created.
			//.......................................................
			SetDlgItemTextFmt(hDlg,IDC_TOTPFILE,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szDestination));

			// Setup the size of the file being created.
			//..........................................
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			_ui64toa(uliMegabytes.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszSizeCreated,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_SIZETOTP,(LPCTSTR)szInBuffer);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for asking how large a true one time pad file we
// want to make.
//....................................................................
LRESULT CALLBACK TrueOneTimePadFileSizeProc(HWND hDlg, UINT uiMsg, WPARAM wParam,
											LPARAM lParam)
{
	BOOL			bError;
	DWORD			dwMegaBytes;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR			szInBuffer[128];
			TCHAR			szFormatedNumber[64];
			TCHAR			szCompactedPath[MAX_PATH];
			
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Setup the drive icon to use.
			//.............................
			hIcon = LoadImage(hInst,lpszWhichDriveIcon,IMAGE_ICON,32,32,LR_SHARED);
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_DRIVEICON),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Set the destination.
			//.....................
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszDestinationFormat,&szRoot);
			SetDlgItemTextFmt(hDlg,IDC_DESTINATION,(LPCTSTR)szInBuffer);

			// Set the statement for how much free space we have on the drive.
			//................................................................
			uliMegabytes.QuadPart = (uliBytesFree.QuadPart / ONEMEGABYTE);
			ZeroMemory(&szInBuffer,sizeof(szInBuffer));
			ZeroMemory(&szFormatedNumber,sizeof(szFormatedNumber));
			_ui64toa(uliMegabytes.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),lpszMegabytesFree,szFormatedNumber);
			SetDlgItemText(hDlg,IDC_STATEMENT1,(LPCTSTR)szInBuffer);

			// Setup the edit box.
			//....................
			SetDlgItemInt(hDlg,IDC_MEGABYTES,0,FALSE);
			SendDlgItemMessage(hDlg,IDC_MEGABYTES,EM_SETLIMITTEXT,(WPARAM)7,0);

			// Set the full destination specification.
			//........................................
			PathCompactPathEx((LPTSTR)&szCompactedPath,(LPCTSTR)&szDestination,75,0);
			SetDlgItemTextFmt(hDlg,IDC_DESTINATION1,(LPCTSTR)&szCompactedPath);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Check out the size of the true one time pad file.
					//..................................................
					uliMegabytes.QuadPart = 0;
					dwMegaBytes = GetDlgItemInt(hDlg,IDC_MEGABYTES,&bError,FALSE);
					uliMegabytes.LowPart = dwMegaBytes;
					uliSize.QuadPart = (dwMegaBytes * ONEMEGABYTE);

					if (uliSize.QuadPart == 0 ||
						uliSize.QuadPart > uliBytesFree.QuadPart)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_TRUEOTPF,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
						SetFocus(GetDlgItem(hDlg,IDC_MEGABYTES));
						break;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Check for a valid True One Time Pad File.
//..........................................
HANDLE IsValidTruePadFile(LPTSTR lpFileName)
{
	ULARGE_INTEGER	uli;
	HANDLE			hTruePadFile;
	BOOL			bResult;
	DWORD			dwBytesRead;
	TCHAR			szBuffer[12];

	// Open the OTP Key File.
	//.......................
	hTruePadFile = CreateMyFile((LPTSTR)lpFileName,GENERIC_READ | GENERIC_WRITE,0,NULL,
								 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hTruePadFile)
		return(FALSE);

	// Read the file header.
	//......................
	bResult = ReadMyFile((LPTSTR)lpFileName,hTruePadFile,&szBuffer,sizeof(szBuffer) -1,
						  &dwBytesRead,NULL);
	if (!bResult)
	{
		CloseMyHandle((LPTSTR)lpFileName,hTruePadFile);
		return(FALSE);
	}
	// Compare the header bytes.
	//..........................
	if (CompareString(LOCALE_SYSTEM_DEFAULT,0,(LPCTSTR) &PadFileID,
					  PAD_ID_SIZE,(LPCTSTR) &szBuffer,PAD_ID_SIZE) != CSTR_EQUAL)
	{
		SetLastError(IDS_NOTVALIDTRUEPADFILE);
		ErrorProcedure((LPTSTR)lpFileName,IDS_TRUEPADFILECHK,MB_OK);
		CloseMyHandle((LPTSTR)lpFileName,hTruePadFile);
		return(FALSE);
	}
	// Reset the file pointer to the beginning of the file.
	//.....................................................
	uli.QuadPart =0;
	uli.QuadPart = SetMyFilePointer((LPTSTR)lpFileName,hTruePadFile,uli.QuadPart,FILE_BEGIN);
	if (uli.QuadPart == -1)
	{
		CloseMyHandle((LPTSTR)lpFileName,hTruePadFile);
		return(FALSE);
	}

	return(hTruePadFile);
}

// Convert a file to a true one time pad file.
//............................................
VOID ConvertMyFile()
{
	DWORD				dwOldHelpTopic;
	ULARGE_INTEGER		uliTotalBytes;
	OPENFILENAME		ofn;
	DWORD				dwBytesWritten;
	DWORD				dwBytesRead;
	WIN32_FIND_DATA		wfd;
	HANDLE				hSearch;
	BOOL				bResult;
	int					iResult;
	HANDLE				hConvertFile = 0;
	TCHAR				szBuffer[128];
	TCHAR				szNewFileName[MAX_PATH];

	bProcessInProgress = TRUE;
	dwOldHelpTopic = ChangeHelpTopic(IDH_CONVERT);

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	// Initialize with specific information for getting a true pad file name.
	//.......................................................................
	ofn.lpstrFile = szDestination;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Convert a File to a True One Time Pad File");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_NONETWORKBUTTON | 
				 OFN_ENABLEHOOK | OFN_ENABLESIZING |OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szDestination,MAX_PATH);

		// Get the name and path we want to use for our public key ring.
		//..............................................................
		if (!GetSaveFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_SAVE_AS);
			goto ConvertEnd;
		}
		SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,TRUE);

		// Check out the file.
		//....................
		hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
		FindClose(hSearch);

		// Make sure the file is over 1 megabyte long.
		//............................................
		uliTotalBytes.LowPart = wfd.nFileSizeLow;
		uliTotalBytes.HighPart = wfd.nFileSizeHigh;

		if (uliTotalBytes.QuadPart < (1024 * 1024))
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_FILETOSMALL,
						   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
			continue;
		}
		// Check out the header to make sure it is not a true one time pad file.
		//......................................................................
		hConvertFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,NULL,
									 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if (!hConvertFile)
		{
			goto ConvertEnd;
		}
		bResult = ReadMyFile((LPTSTR)&szDestination,hConvertFile,&szBuffer,12,&dwBytesRead,
							  NULL);
		if (!bResult)
		{
			goto ConvertEnd;
		}
		// Compare the first 4 bytes of the buffer for the pad1 string.
		//.............................................................
		iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&PadFileID,4,
								(LPCTSTR)&szBuffer,4);
		if (iResult == CSTR_EQUAL)
		{
			bResult = CloseMyHandle((LPTSTR)&szDestination,hConvertFile);
			if (!bResult)
			{
				goto ConvertEnd;
			}
			hConvertFile = 0;

			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_ALREADYTOTPF,
						   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
			continue;
		}
		break;
	}
	// We have a good file to convert, so do it.
	//..........................................
	uliTotalBytes.QuadPart = 0;
	uliTotalBytes.QuadPart = SetMyFilePointer((LPTSTR)&szDestination,hConvertFile,
											   uliTotalBytes.QuadPart,FILE_BEGIN);
	if (uliTotalBytes.QuadPart == -1)
	{
		goto ConvertEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szDestination,hConvertFile,&PadHeader,12,&dwBytesWritten,
						   NULL);
	if (!bResult)
	{
		goto ConvertEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szDestination,hConvertFile);
	if (!bResult)
	{
		goto ConvertEnd;
	}
	hConvertFile = 0;

	// Rename the file.
	//.................
	CopyMemory(&szNewFileName,&szDestination,MAX_PATH);
	PathRemoveExtension((LPTSTR)&szNewFileName);
	PathAddExtension((LPTSTR)&szNewFileName,(LPCTSTR)TEXT(".pad"));
	bResult = MoveFile((LPCTSTR)&szDestination,(LPCTSTR)&szNewFileName);

	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_RENAMEFILE,MB_OK);
		goto ConvertEnd;
	}
	SaveDirName((LPBYTE)&szDestination,SAVE_TOTPFILES,TRUE);

	ConvertEnd:

	if (hConvertFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hConvertFile);
	}
	bCancelOperation = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// Hash buffer output for true one time pad file. Buffer is a set size.
//.....................................................................
VOID HashBuffer(LPBYTE lpBuffer, DWORD dwBuffSize)
{
	LPBYTE				lpBuff = lpBuffer;
	DWORD				dwSize;

	dwSize = dwBuffSize / SHA_DIGEST_SIZE;

	while (dwSize > 0)
	{
		ShaInit(&ShaContext);
		ShaUpdate(&ShaContext,lpBuff,SHA_DIGEST_SIZE);
		ShaFinal(lpBuff,&ShaContext);
		lpBuff += SHA_DIGEST_SIZE;
		dwSize--;
	}
}

